#include <iostream>
#include <vector>
#include <cassert>
#include <cmath>
#include <ctime>
#include <cstdio>
#include <queue>
#include <set>
#include <map>
#include <fstream>
#include <cstdlib>
#include <string>
#include <cstring>
#include <algorithm>
#include <numeric>

#define mp make_pair
#define pb push_back
#define fi first
#define se second
#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define forn(i, n) for (int i = 0; i < (int)(n); ++i)
#define for1(i, n) for (int i = 1; i <= (int)(n); ++i)
#define ford(i, n) for (int i = (int)((n) - 1); i >= 0; --i)
#define fornn(i, a, b) for (int i = (int)(a); i < (int)(b); ++i)
#define fore(i, a, b) for (int i = (int)(a); i <= (int)(b); ++i)
#define debugv(a) forn(i, a.size()) cerr << a[i] << ' '; cerr << '\n'

using namespace std;

typedef pair<int, int> pii;
typedef vector<int> vi;
typedef vector<vi> vvi;

typedef long long i64;
typedef unsigned long long u64;
typedef pair<i64, i64> pi64;
typedef vector<i64> vi64;
typedef vector<vi64> vvi64;

typedef long double ld;
typedef vector<ld> vld;
typedef vector<vld> vvld;

const double PI = atan2(0, -1);

double angle(pii a, pii b, pii c) {
    return PI - fabs(atan2((c.fi - b.fi) * (a.se - b.se) - (c.se - b.se) * (a.fi - b.fi), (c.fi - b.fi) * (a.fi - b.fi) + (c.se - b.se) * (a.se - b.se)));
}

const int MAXN = 10000;
pii p[MAXN];
vector<pii> e[MAXN];
vector<pii> match[MAXN];
vi cs[MAXN];
int ct = 0;
int used[2 * MAXN], vused[MAXN];
int bubu[2 * MAXN];

double total = 0.0;

void make_match(int v, int id1, int id2) {
    match[v].pb(mp(id1, id2));
}

void dfs(int v, vector<pii> &path) {
    vused[v] ^= 1;
    for (pii q: e[v]) {
        if (used[q.se]) continue;
        used[q.se] = 1;
        path.pb(q);
        if (vused[q.fi]) {
            pii r;
            int cc = ct++;
            while (1) {
                r = path.back();
                path.pop_back();
                cs[r.fi].pb(cc);
                vused[r.fi] ^= 1;
//                cerr << r.fi << ' ';
                if (path.empty() || path.back().fi == q.fi) break;
                make_match(path.back().fi, path.back().se, r.se);
            }
//            cerr << '\n';
            make_match(q.fi, r.se, q.se);
        }
        dfs(q.fi, path);
        break;
    }
}

int par[2 * MAXN];

int root(int v) {
    if (v == par[v]) return v;
    return par[v] = root(par[v]);
}

void unite(int u, int v) {
    u = root(u);
    v = root(v);
    par[u] = v;
}

int main() {
    ios::sync_with_stdio(false);
#ifdef LOCAL_DEFINE
    freopen("input.txt", "rt", stdin);
//    freopen("output.txt", "wt", stdout);
#endif

    int N, M;
    cin >> N >> M;
    forn(i, N) cin >> p[i].fi >> p[i].se;

    forn(i, M) {
        int x, y;
        cin >> x >> y;
        e[x].pb(mp(y, i));
        e[y].pb(mp(x, i));
        bubu[i] = x ^ y;
    }

    vector<pii> path;
    forn(i, N) {
        dfs(i, path);
        dfs(i, path);
    }

    forn(i, N) {
        for (pii q: match[i]) {
            total += angle(p[i ^ bubu[q.fi]], p[i], p[i ^ bubu[q.se]]);
//            cerr << i << ' ' << q.fi << ' ' << q.se << '\n';
        }
    }

//    cout << total << '\n';
bububu
    vector< pair<double, pii> > ne;
    forn(i, N) {
        if (e[i].size() == 2) continue;
        vi ch;
        pii q1 = match[i][0], q2 = match[i][1];
        double t = angle(p[i ^ bubu[q1.fi]], p[i], p[i ^ bubu[q1.se]]) + angle(p[i ^ bubu[q2.fi]], p[i], p[i ^ bubu[q2.se]]);

        double cost1 = angle(p[i ^ bubu[q1.fi]], p[i], p[i ^ bubu[q2.fi]]) + angle(p[i ^ bubu[q1.se]], p[i], p[i ^ bubu[q2.se]]);
        double cost2 = angle(p[i ^ bubu[q1.fi]], p[i], p[i ^ bubu[q2.se]]) + angle(p[i ^ bubu[q1.se]], p[i], p[i ^ bubu[q2.fi]]);
        ne.pb(mp(min(cost1, cost2) - t, mp(cs[i][0], cs[i][1])));
        cerr << cs[i][0] << ' ' << cs[i][1] << ' ' << t - min(cost1, cost2) << '\n';
    }

    sort(all(ne));
    forn(i, ct) par[i] = i;
    for (auto q: ne) {
        int x = q.se.fi, y = q.se.se;
        if (root(x) != root(y)) {
            unite(x, y);
            total += q.fi;
        }
    }

    printf("%.10lf\n", total);


#ifdef LOCAL_DEFINE
    cerr << "Time elapsed: " << 1.0 * clock() / CLOCKS_PER_SEC << " s.\n";
#endif
    return 0;
}
